﻿#include "precompiled.h"
#include "BasicTimer.h"

namespace RTCam {

BasicTimer::BasicTimer() :
	m_frequency(),
	m_currentTime(),
	m_startTime(),
	m_lastTime(),
	m_total(0),
	m_delta(0)
{
	if (!QueryPerformanceFrequency(&m_frequency))
	{
		throw std::exception("Error calling QueryPerformanceFrequency");
	}
	Reset();
}

void BasicTimer::Reset()
{
	Update();
	m_startTime = m_currentTime;
	m_total = 0.0f;
	m_delta = 1.0f / 60.0f;
}

void BasicTimer::Update()
{
	if (!QueryPerformanceCounter(&m_currentTime))
	{
		throw std::exception("Error calling QueryPerformanceFrequency");
	}

	m_total = static_cast<float>(
		static_cast<double>(m_currentTime.QuadPart - m_startTime.QuadPart) /
		static_cast<double>(m_frequency.QuadPart)
		);

	if (m_lastTime.QuadPart == m_startTime.QuadPart)
	{
		// If the timer was just reset, report a time delta equivalent to 60Hz frame time.
		m_delta = 1.0f / 60.0f;
	}
	else
	{
		m_delta = static_cast<float>(
			static_cast<double>(m_currentTime.QuadPart - m_lastTime.QuadPart) /
			static_cast<double>(m_frequency.QuadPart)
			);
	}

	m_lastTime = m_currentTime;
}

} // end namespace